# 开发工作流规范

> 🥇 适用于前后端项目开发

## 开发前必读 🔥

以下内容，项目负责人及开发团队成员务必遵守，共同营造一个良好的开发环境

1. 使用代码规范检查工具（前端：`ESLint`，后端：`Spotless`），规范项通常使用业内标准，再由团队协商调整部分检查项
2. 使用代码格式规范工具统一编码风格（前端：`Prettier`，后端：`Spotless + Prettier for Java`）
3. 使用 `GitHook` 来自动化规范提交前的代码初步检查
4. ~~TODO...~~

## 代码管理规范 ⚠️

重要：所有项目统一由负责人在 GitLab 上创建群组，与项目有关的前后端工程，全部在群组内预先创建好，并分配人员，不允许将项目挂在私人账号下进行协同开发。

## Git 规范 ✅

简化使用 [git-flow](https://www.gitflow.com/)，具体说明参考如下

### 分支规范

1. master (主分支)
2. develop (开发分支)
3. dev_fzm (开发人员分支，fzm 代表用户方治民)
4. release、hotfix (视情况产生的分支，用完删除)

共包含五种类型的分支，暂定工作流程图如下

![image](http://img.ifzm.cn/git-flow.2020-02-14.png)

develop 分支允许开发时用于代码合并，保持最新的汇总版本

develop 分支之上为权限分支，仅由负责人负责合并代码或创建新分支，以及发布版本

### 提交规范

> **推荐方式**: 使用 [cz-cli](https://github.com/commitizen/cz-cli) 来提交代码，推荐使用 `cz-conventional-changelog` 插件来提交更新日志

<!-- prettier-ignore -->
- 禁止提交自己的本地配置，如：`.idea/.vscode`、`local/env` 配置(特殊情况下需要团队保持强一致时可以提交)
- 禁止提交不能通过编译的代码
- 养成早提交、多提交习惯，最好每开发一个功能都 `commit` 一次，提交前需要先更新

### Commit Message 规范

规范 `Commit Message` 格式（注意冒号后面有空格）

```md
<type>: <subject> <#id>
```

#### 常用的 type 类别

<!-- prettier-ignore -->
- `feat`：新增 xxx 功能
- `fix`：修复 xxx Bug
- `docs`：变更 xxx 文档
- `style`： 变更 xxx 代码格式或注释
- `refactor`：重构 xxx 功能或方法
- `test`：调试 xxx 功能或新增 xxx 测试用例
- `chore`：构建过程或辅助工具的变动（较少出现，项目构建之初基本已确定好）
- `build`: 发布 v0.0.1 版本

#### subject 简述

`subject` 是 `commit` 描述信息，尽可能简明扼要。

#### id 标识

`#id` 代表 [PingCode](https://yiring.pingcode.com) 任务、Bug 编号（可选，如果有对应的必须填写）

#### 示例

```sh
git commit -m 'feat: 新增用户登录功能'
git commit -m 'fix: 修复由 token 问题引起的需要重复登录 Bug #1002'
```
