/* (C) 2022 YiRing, Inc. */
package com.yiring.auth.param.permission;

import com.alibaba.fastjson2.JSONObject;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.yiring.auth.domain.permission.Permission;
import com.yiring.common.validation.group.Group;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.io.Serial;
import java.io.Serializable;
import lombok.*;
import lombok.experimental.FieldDefaults;

/**
 * 权限信息入参类
 *
 * @author Jim
 * @version 0.1
 * 2022/3/25 17:09
 */

@JsonInclude(JsonInclude.Include.NON_NULL)
@Schema(name = "PermissionParam")
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
public class PermissionParam implements Serializable {

    @Serial
    private static final long serialVersionUID = -6781934969837655538L;

    @Schema(description = "id", example = "1")
    @NotBlank(groups = { Group.Edit.class })
    String id;

    @Schema(description = "权限类型", example = "MENU")
    @NotNull(message = "权限类型不能为空")
    Permission.Type type;

    @Schema(description = "序号", example = "1")
    Integer serial;

    @Schema(description = "标识", example = "Dashboard")
    @NotEmpty(message = "权限标识不能为空")
    String uid;

    @Schema(description = "名称", example = "Dashboard")
    @NotEmpty(message = "权限名称不能为空")
    String name;

    @Schema(description = "路径", example = "/dashboard")
    String path;

    @Schema(description = "重定向", example = "/dashboard/workbench")
    String redirect;

    @Schema(description = "组件", example = "LAYOUT")
    String component;

    @Schema(description = "图标", example = "ion:grid-outline")
    String icon;

    @Schema(description = "是否隐藏", example = "false")
    Boolean hidden;

    @Schema(description = "是否禁用", example = "false")
    Boolean disabled;

    @Schema(description = "父级ID", example = "0")
    @Builder.Default
    String pid = "0";

    @Schema(description = "元数据", example = "{\"title\": \"routes.dashboard.dashboard\"}")
    JSONObject meta;
}
