/* (C) 2022 YiRing, Inc. */
package com.yiring.auth.param.role;

import com.yiring.common.validation.group.Group;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import java.io.Serial;
import java.io.Serializable;
import lombok.*;
import lombok.experimental.FieldDefaults;

/**
 * 角色信息入参类
 *
 * @author Jim
 * @version 0.1
 * 2022/3/25 17:09
 */

@Schema(name = "RoleParam")
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
public class RoleParam implements Serializable {

    @Serial
    private static final long serialVersionUID = 6572751635422870217L;

    @Parameter(description = "id", example = "1")
    @NotBlank(groups = { Group.Edit.class })
    String id;

    @Parameter(description = "标识", example = "admin")
    @NotEmpty(message = "角色标识不能为空")
    String uid;

    @Parameter(description = "名称", example = "管理员")
    @NotEmpty(message = "角色名称不能为空")
    String name;
}
