/* (C) 2022 YiRing, Inc. */
package com.yiring.auth.vo.permission;

import com.alibaba.fastjson2.JSONObject;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.yiring.auth.domain.permission.Permission;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serial;
import java.io.Serializable;
import java.util.List;
import lombok.*;
import lombok.experimental.FieldDefaults;

/**
 * 权限输出类
 *
 * @author Jim
 * @version 0.1
 * 2022/3/25 17:09
 */

@JsonInclude(JsonInclude.Include.NON_NULL)
@Schema(name = "PermissionVo")
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
public class PermissionVo implements Serializable {

    @Serial
    private static final long serialVersionUID = -9139328772148985141L;

    @Parameter(description = "主键", example = "1")
    String id;

    @Parameter(description = "权限类型", example = "MENU")
    Permission.Type type;

    @Parameter(description = "序号", example = "1")
    Integer serial;

    @Parameter(description = "标识", example = "home")
    String uid;

    @Parameter(description = "名称", example = "主页")
    String name;

    @Parameter(description = "路径", example = "/")
    String path;

    @Parameter(description = "组件", example = "/home")
    String component;

    @Parameter(description = "图标", example = "menu")
    String icon;

    @Parameter(description = "是否隐藏", example = "false")
    Boolean hidden;

    @Parameter(description = "是否禁用", example = "false")
    Boolean disabled;

    @Parameter(description = "父级ID", example = "0")
    String pid;

    @Parameter(description = "元数据", example = "{\"title\": \"routes.dashboard.dashboard\"}")
    JSONObject meta;

    @Parameter(description = "子权限")
    List<PermissionVo> children;
}
