/* (C) 2023 YiRing, Inc. */
package com.yiring.common.annotation;

import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.lang.annotation.*;
import org.springframework.core.annotation.AliasFor;
import org.springframework.http.MediaType;

/**
 * 下载响应注解
 *
 * @author Jim
 * @version 0.1
 * 2023/1/12 11:22
 */

@SuppressWarnings({ "unused" })
@Target({ ElementType.METHOD, ElementType.TYPE, ElementType.ANNOTATION_TYPE })
@Retention(RetentionPolicy.RUNTIME)
@Inherited
@ApiResponse
public @interface DownloadResponse {
    @AliasFor(annotation = ApiResponse.class)
    String responseCode() default "200";

    @AliasFor(annotation = ApiResponse.class)
    String description() default "OK";

    @AliasFor(annotation = ApiResponse.class)
    Content content() default @Content(
        schema = @Schema(type = "file", format = "binary"),
        mediaType = MediaType.APPLICATION_OCTET_STREAM_VALUE
    );
}
