/* (C) 2021 YiRing, Inc. */
package com.yiring.common.core;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.yiring.common.utils.Uptime;
import java.io.Serial;
import java.io.Serializable;
import lombok.AccessLevel;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.FieldDefaults;

/**
 * 标准的响应对象（所有的接口响应内容格式都应该是一致的）
 *
 * @author ifzm
 * @version 1.1
 * 2018/9/4 11:05
 */

@JsonInclude(JsonInclude.Include.NON_NULL)
@Data
@Builder
@FieldDefaults(level = AccessLevel.PRIVATE)
public class UptimeNotice implements Serializable {

    @Serial
    private static final long serialVersionUID = -4250534970217176081L;

    /**
     * 状态
     */
    Uptime.Status status;

    /**
     * 消息
     */
    String msg;

    /**
     * 返回成功响应内容（默认）
     *
     * @return UptimeNotice
     * @see Uptime.Status#UP
     */
    public static UptimeNotice ok() {
        return ok("OK");
    }

    /**
     * 返回自定义成功响应内容
     *
     * @return UptimeNotice
     * @see Uptime.Status
     */
    public static UptimeNotice ok(String msg) {
        return UptimeNotice.builder().status(Uptime.Status.UP).msg(msg).build();
    }

    /**
     * 返回默认的 400 错误响应
     *
     * @return UptimeNotice
     * @see Uptime.Status#DOWN
     */
    public static UptimeNotice no() {
        return no("Fail");
    }

    /**
     * 返回自定义成功响应内容
     *
     * @return UptimeNotice
     * @see Uptime.Status
     */
    public static UptimeNotice no(String msg) {
        return UptimeNotice.builder().status(Uptime.Status.DOWN).msg(msg).build();
    }
}
