/* (C) 2021 YiRing, Inc. */
package com.yiring.common.param;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import java.io.Serial;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import lombok.*;
import lombok.experimental.FieldDefaults;

/**
 * 公共的 ID 集合查询参数类
 *
 * @author ifzm
 * @version 0.1
 * 2019/5/28 22:11
 */
@Schema(name = "IdsParam")
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
public class IdsParam implements Serializable {

    @Serial
    private static final long serialVersionUID = -8379896695668632733L;

    @Parameter(description = "ids 多个以逗号分割", example = "1,2")
    @NotBlank
    Set<String> ids;

    /**
     * 获取 String 类型的 ID 集合
     *
     * @return ID 集合
     */
    public Collection<Serializable> toIds() {
        return Collections.unmodifiableSet(ids);
    }
}
