/* (C) 2021 YiRing, Inc. */
package com.yiring.common.param;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import java.io.Serial;
import java.io.Serializable;
import lombok.*;
import lombok.experimental.FieldDefaults;

/**
 * 公共的父级 ID 查询参数类
 *
 * @author ifzm
 * @version 0.1
 * 2019/5/28 22:11
 */
@Schema(name = "PidParam", description = "公共的父级 ID 查询参数")
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
public class PidParam implements Serializable {

    @Serial
    private static final long serialVersionUID = -8690942241103456893L;

    @Parameter(description = "pid", example = "0")
    @NotBlank
    String pid;
}
