/* (C) 2021 YiRing, Inc. */
package com.yiring.common.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serial;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldDefaults;

/**
 * 公共数据响应
 *
 * @author ifzm
 * @version 0.1
 * 2022/3/23 16:47
 */
@Schema(name = "DataVo", description = "公共数据响应输出")
@Data
@NoArgsConstructor
@AllArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
public class DataVo<T extends Serializable> implements Serializable {

    @Serial
    private static final long serialVersionUID = 2472779197432240431L;

    @Schema(description = "数据")
    T data;

    /**
     * 通常在带有时效性的数据查询时有用途（可选参数）
     */
    @Schema(description = "数据最新时间")
    LocalDateTime latest;

    /**
     * 构建一个 DataVo
     *
     * @param data 数据
     * @return DataVo
     */
    @SuppressWarnings({ "unused" })
    public static <R extends Serializable> DataVo<R> build(R data) {
        return build(data, null);
    }

    /**
     * 构建一个 DataVo
     *
     * @param data   数据
     * @param latest 数据最新时间
     * @return DataVo
     */
    @SuppressWarnings({ "unused" })
    public static <R extends Serializable> DataVo<R> build(R data, LocalDateTime latest) {
        DataVo<R> vo = new DataVo<>();
        vo.setData(data);
        vo.setLatest(latest);
        return vo;
    }
}
