/* (C) 2021 YiRing, Inc. */
package com.yiring.common.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serial;
import java.io.Serializable;
import java.util.List;
import lombok.*;
import lombok.experimental.FieldDefaults;

/**
 * 选项 VO
 *
 * @author ifzm
 * @version 0.1
 * 2022/3/24 17:29
 */

@Schema(name = "OptionVo", description = "选项 VO")
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
public class OptionVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 7178232019485233157L;

    @Schema(description = "value", example = "value")
    String value;

    @Schema(description = "label", example = "label")
    String label;

    @Schema(description = "disabled", example = "false")
    Boolean disabled;

    @Schema(description = "extra")
    Object extra;

    @Schema(description = "children", example = "[]")
    List<OptionVo> children;
}
