/* (C) 2021 YiRing, Inc. */
package com.yiring.common.config;

import cn.hutool.core.lang.Console;
import com.xxl.job.core.executor.impl.XxlJobSpringExecutor;
import lombok.AccessLevel;
import lombok.Data;
import lombok.RequiredArgsConstructor;
import lombok.experimental.FieldDefaults;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

/**
 * Swagger Config
 *
 * @author ifzm
 * @version 0.1
 * 2019/3/11 19:13
 */

@Slf4j
@Data
@FieldDefaults(level = AccessLevel.PRIVATE)
@Order(value = 9999998)
@Configuration
@ConditionalOnProperty(prefix = "xxl.job", value = "enabled", havingValue = "true")
@RequiredArgsConstructor
public class XxlJobConfiguration implements CommandLineRunner {

    final XxlJobConfig xxlJobConfig;

    @Bean
    public XxlJobSpringExecutor xxlJobExecutor() {
        XxlJobSpringExecutor xxlJobSpringExecutor = new XxlJobSpringExecutor();
        xxlJobSpringExecutor.setAdminAddresses(xxlJobConfig.getAdminAddresses());
        xxlJobSpringExecutor.setAppname(xxlJobConfig.getExecutorAppName());
        xxlJobSpringExecutor.setAddress(xxlJobConfig.getExecutorAddress());
        xxlJobSpringExecutor.setIp(xxlJobConfig.getExecutorIp());
        xxlJobSpringExecutor.setPort(xxlJobConfig.getExecutorPort());
        xxlJobSpringExecutor.setAccessToken(xxlJobConfig.getAccessToken());
        xxlJobSpringExecutor.setLogPath(xxlJobConfig.getExecutorLogPath());
        xxlJobSpringExecutor.setLogRetentionDays(xxlJobConfig.getExecutorLogRetentionDays());
        return xxlJobSpringExecutor;
    }

    @Override
    public void run(String... args) {
        Console.log("\n\t⌛ Task Scheduler (XXL-JOB): \n\t\t> {}", xxlJobConfig.getAdminAddresses());
    }
}
