/* (C) 2022 YiRing, Inc. */
package com.yiring.common.vo;

import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.io.Serial;
import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Image 信息
 *
 * @author Jim
 * @version 0.1
 * 2022/8/15 10:02
 */

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ImageInfo implements Serializable, AutoCloseable {

    @Serial
    private static final long serialVersionUID = 4042804283860857802L;

    /**
     *
     */
    BufferedImage image;

    /**
     * IO
     */
    InputStream stream;

    /**
     * 内容大小
     */
    long size;

    /**
     * 类型，eg: image/png
     */
    String contentType;

    /**
     * 后缀，eg: png
     */
    String suffix;

    /**
     * 图片宽度
     */
    int width;

    /**
     * 图片高度
     */
    int height;

    @Override
    public void close() throws Exception {
        if (stream != null) {
            stream.close();
        }
    }
}
