/* (C) 2023 YiRing, Inc. */
package com.yiring.dict.domain;

import static com.yiring.dict.domain.Category.DELETE_SQL;
import static com.yiring.dict.domain.Category.TABLE_NAME;

import com.yiring.common.domain.BasicEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Index;
import jakarta.persistence.Table;
import java.io.Serial;
import java.io.Serializable;
import lombok.*;
import lombok.experimental.FieldDefaults;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;
import org.hibernate.annotations.Comment;
import org.hibernate.annotations.SQLDelete;

/**
 * 分类字典
 *
 * @author Jim
 * @version 0.1
 * 2023/1/20 13:58
 */

@Getter
@Setter
@SuperBuilder(toBuilder = true)
@NoArgsConstructor
@AllArgsConstructor
@FieldNameConstants
@FieldDefaults(level = AccessLevel.PRIVATE)
@SQLDelete(sql = DELETE_SQL + BasicEntity.Where.WHERE_ID)
//@SQLDeleteAll(sql = DELETE_SQL)
@Entity
@Table(
    name = TABLE_NAME,
    indexes = {
        @Index(columnList = BasicEntity.Fields.deleted),
        @Index(columnList = Category.Fields.name),
        @Index(columnList = Category.Fields.code),
    }
)
@Comment("分类字典")
public class Category extends BasicEntity implements Serializable {

    public static final String TABLE_NAME = "SYS_CATEGORY";
    public static final String DELETE_SQL = "update " + TABLE_NAME + Where.DELETE_SET;
    public static final String DEFAULT_TOP_PID = "0";

    @Serial
    private static final long serialVersionUID = -3537807812313662319L;

    @Comment("分类名称")
    @Column(nullable = false)
    String name;

    @Comment("分类编号")
    @Column(nullable = false, unique = true)
    String code;

    @Comment("分类描述")
    String description;

    @Comment("分类父级 ID")
    String pid;

    @Comment("是否禁用")
    @Column(columnDefinition = "bool default false", nullable = false)
    Boolean disabled;
}
