/* (C) 2021 YiRing, Inc. */
package com.yiring.app.config;

import com.yiring.common.core.Result;
import com.yiring.common.core.Status;
import io.sentry.Sentry;
import io.swagger.v3.oas.annotations.Hidden;
import lombok.extern.slf4j.Slf4j;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

/**
 * 全局错误处理
 *
 * @author ifzm
 * 2017年11月30日 上午11:36:31
 */
@Slf4j
@Order
@Hidden
@RestControllerAdvice
public class GlobalExceptionHandler {

    /**
     * 其他异常
     *
     * @param e 异常信息
     * @return 统一的500异常信息 {@link Status#INTERNAL_SERVER_ERROR
     */
    @ResponseStatus(code = HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(Exception.class)
    public Result<String> defaultErrorHandler(Exception e) {
        try {
            log.error(e.getMessage(), e);
            return Result.no(Status.INTERNAL_SERVER_ERROR, e);
        } finally {
            Sentry.captureException(e);
        }
    }
}
