/* (C) 2022 YiRing, Inc. */
package com.yiring.app.vo.user;

import com.yiring.common.jackson.MappingSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serial;
import java.io.Serializable;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldDefaults;

/**
 * @author Jim
 * @version 0.1
 * 2022/7/13 11:36
 */

@Schema(name = "UserExtensionVo", description = "用户扩展信息")
@Data
@NoArgsConstructor
@AllArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
public class UserExtensionVo implements Serializable {

    @Serial
    private static final long serialVersionUID = -2251567849918281906L;

    @Schema(description = "性别", example = "男", allowableValues = { "男", "女" }, type = "string")
    @MappingSerialize(mapping = "0:女,1:男")
    Integer gender;

    @Schema(description = "年龄", example = "18")
    Integer age;

    @Schema(description = "简介", example = "Hi")
    String introduction;
}
