/* (C) 2025 YiRing, Inc. */
package com.yiring.app.web.common;

import cn.dev33.satoken.annotation.SaIgnore;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.yiring.common.core.Result;
import com.yiring.common.param.InputParam;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.jasypt.encryption.StringEncryptor;
import org.springdoc.core.annotations.ParameterObject;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Jim
 */
@Slf4j
@Validated
@ApiSupport(order = -99998)
@Tag(name = "Jasypt", description = "Jasypt")
@RequestMapping("/jasypt/")
@RestController
@RequiredArgsConstructor
public class JasyptController {

    final StringEncryptor encryptor;

    @SaIgnore
    @Operation(summary = "加密字符串")
    @PostMapping("encrypt")
    public Result<String> encrypt(@ParameterObject @Validated InputParam param) {
        String encrypt = encryptor.encrypt(param.getInput());
        return Result.ok(encrypt);
    }

    @SaIgnore
    @Operation(summary = "解密字符串")
    @PostMapping("decrypt")
    public Result<String> decrypt(@ParameterObject @Validated InputParam param) {
        String decrypt = encryptor.decrypt(param.getInput());
        return Result.ok(decrypt);
    }
}
