/* (C) 2024 YiRing, Inc. */
package com.yiring.auth.domain.log;

import com.yiring.common.domain.BasicEntity;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import java.io.Serial;
import java.io.Serializable;
import lombok.*;
import lombok.experimental.FieldDefaults;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;
import org.hibernate.annotations.Comment;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.SQLRestriction;

/**
 * @author Jim
 */
@Getter
@Setter
@SuperBuilder(toBuilder = true)
@NoArgsConstructor
@AllArgsConstructor
@FieldNameConstants
@FieldDefaults(level = AccessLevel.PRIVATE)
@SQLDelete(sql = LoginLog.DELETE_SQL + BasicEntity.Where.WHERE_ID)
@SQLRestriction(BasicEntity.Where.EXIST)
@Entity
@Table(name = LoginLog.TABLE_NAME)
@Comment("系统用户登录日志")
public class LoginLog extends BasicEntity implements Serializable {

    @Serial
    private static final long serialVersionUID = -3979598668491115376L;

    public static final String TABLE_NAME = "SYS_LOGIN_LOG";
    public static final String DELETE_SQL = "update " + TABLE_NAME + BasicEntity.Where.DELETE_SET;

    @Comment("登录账号")
    String account;

    @Comment("登录IP地址")
    String ip;

    @Comment("登录地点")
    String location;

    @Comment("User-Agent")
    String ua;

    @Comment("操作系统")
    String os;

    @Comment("平台")
    String platform;

    @Comment("浏览器")
    String browser;

    @Comment("登录状态")
    Boolean status;

    @Comment("登录消息")
    String msg;
}
