/* (C) 2021 YiRing, Inc. */
package com.yiring.auth.param.auth;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.Pattern;
import java.io.Serial;
import java.io.Serializable;
import lombok.*;
import lombok.experimental.FieldDefaults;

/**
 * 用户注册参数
 *
 * @author ifzm
 * @version 0.1
 * 2019/5/28 22:11
 */
@Schema(name = "RegisterParam")
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
public class RegisterParam implements Serializable {

    @Serial
    private static final long serialVersionUID = -8690942241103456895L;

    @Parameter(description = "用户名", example = "admin")
    @NotEmpty(message = "用户名不能为空")
    String username;

    @Parameter(description = "密码", example = "123456")
    @NotEmpty(message = "密码不能为空")
    String password;

    @Parameter(description = "真实姓名", example = "管理员")
    @NotEmpty(message = "真实姓名不能为空")
    String realName;

    @Parameter(description = "手机号", example = "13012345678")
    @NotEmpty(message = "手机号不能为空")
    @Pattern(regexp = "^1\\d{10}$", message = "手机号码格式不正确")
    String mobile;

    @Parameter(description = "头像", example = "https://s1.ax1x.com/2022/03/30/qggJH0.jpg")
    String avatar;

    @Parameter(description = "邮箱", example = "developer@yiring.com")
    String email;

    @Parameter(description = "是否禁用", example = "false")
    Boolean disabled;
}
