/* (C) 2021 YiRing, Inc. */
package com.yiring.auth.param.auth;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import java.io.Serial;
import java.io.Serializable;
import lombok.*;
import lombok.experimental.FieldDefaults;

/**
 * 安全校验参数
 *
 * @author ifzm
 * @version 0.1
 * 2019/5/28 22:11
 */
@Schema(name = "SafeParam")
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
public class SafeParam implements Serializable {

    @Serial
    private static final long serialVersionUID = 9106494470582579138L;

    @Parameter(description = "密码", example = "123456")
    @NotEmpty(message = "密码不能为空")
    String password;
}
