/* (C) 2022 YiRing, Inc. */
package com.yiring.auth.vo.user;

import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serial;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.*;
import lombok.experimental.FieldDefaults;

/**
 * 用户信息
 *
 * @author ifzm
 * 2022/03/03 10:35
 **/

@Schema(name = "UserVo")
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
public class UserVo implements Serializable {

    @Serial
    private static final long serialVersionUID = -2184378273450466835L;

    @Schema(description = "主键", example = "1")
    String id;

    @Schema(description = "真实姓名", example = "超级用户")
    String realName;

    @Schema(description = "用户名", example = "admin")
    String username;

    @Schema(description = "手机号", example = "13012345678")
    String mobile;

    @Schema(description = "邮箱", example = "developer@yiring.com")
    String email;

    @Schema(description = "职称", example = "系统管理员")
    String title;

    @Schema(description = "头像", example = "https://s1.ax1x.com/2022/03/30/qggJH0.jpg")
    String avatar;

    @Schema(description = "是否禁用", example = "false")
    Boolean disabled;

    @Schema(description = "是否删除", example = "false")
    Boolean deleted;

    @Schema(description = "最后登录IP地址", example = "127.0.0.1")
    String lastLoginIp;

    @Schema(description = "最后登录时间", example = "2022-10-24 10:24:00")
    LocalDateTime lastLoginTime;

    @Schema(description = "最后登录时间", example = "2022-01-01 00:00:00")
    LocalDateTime createTime;
}
