/* (C) 2022 YiRing, Inc. */
package com.yiring.common.config;

import java.io.Serial;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import lombok.AccessLevel;
import lombok.Data;
import lombok.experimental.FieldDefaults;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

/**
 * Env 环境变量配置注入
 *
 * @author Jim
 * @version 0.1
 * 2021/9/16 16:37
 */

@Data
@FieldDefaults(level = AccessLevel.PRIVATE)
@Configuration("env.config")
@ConfigurationProperties(prefix = "env")
public class EnvConfig implements Serializable {

    @Serial
    private static final long serialVersionUID = 1017213697767634790L;

    /**
     * host，用来共享一些资源（如：数据库、文件存储等相关的依赖源）
     */
    String host;

    /**
     * 是否为生产环境
     */
    boolean prod;

    /**
     * 其他配置
     */
    Map<String, String> props = new HashMap<>();
}
