/* (C) 2024 YiRing, Inc. */
package com.yiring.common.config;

import java.io.Serial;
import java.io.Serializable;
import lombok.AccessLevel;
import lombok.Data;
import lombok.experimental.FieldDefaults;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

/**
 * @author Jim
 */
@Data
@FieldDefaults(level = AccessLevel.PRIVATE)
@Configuration("logging.loki")
@ConfigurationProperties(prefix = "logging.loki")
public class LokiConfig implements Serializable {

    @Serial
    private static final long serialVersionUID = 537555929100019498L;

    /**
     * 是否启用
     */
    boolean enabled;

    /**
     * 推送地址
     */
    String url;
}
