/* (C) 2024 YiRing, Inc. */
package com.yiring.common.config;

import cn.hutool.core.util.StrUtil;
import jakarta.annotation.PostConstruct;
import lombok.AccessLevel;
import lombok.Data;
import lombok.experimental.FieldDefaults;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

/**
 * @author Jim
 */
@Slf4j
@Data
@FieldDefaults(level = AccessLevel.PRIVATE)
@Order(99999999)
@Configuration
@ConfigurationProperties(prefix = "uptime")
public class UptimeConfig {

    /**
     * Uptime 服务域名
     */
    String domain;

    @PostConstruct
    public void init() {
        String defaultUptimeDomain = "https://uptime.yiring.com";
        if (StrUtil.isBlank(domain)) {
            domain = defaultUptimeDomain;
            log.info(
                "[Uptime Config] No `uptime.domain` configuration detected, using default domain: {}",
                defaultUptimeDomain
            );
        } else {
            log.info("[Uptime Config] Uptime domain: {}", domain);
        }
    }
}
