/* (C) 2021 YiRing, Inc. */
package com.yiring.common.param;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import java.io.Serial;
import java.io.Serializable;
import lombok.*;
import lombok.experimental.FieldDefaults;

/**
 * 公共的输入参数
 *
 * @author ifzm
 * @version 0.1
 * 2022/4/27 08:53
 */
@Schema(name = "InputParam", description = "公共的输入参数")
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
public class InputParam implements Serializable {

    @Serial
    private static final long serialVersionUID = -8690942241103456895L;

    @Parameter(description = "输入值", example = "value")
    @NotBlank
    String input;
}
