/* (C) 2024 YiRing, Inc. */
package com.yiring.common.snowflake;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import org.hibernate.annotations.IdGeneratorType;
import org.hibernate.annotations.ValueGenerationType;

/**
 * 雪花 ID 生成器
 * <p>
 * 支持自动识别 Long 和 String 类型的 ID 生成
 *
 * @author Jim
 */
@IdGeneratorType(SnowflakeIdGeneratorAccomplish.class)
@ValueGenerationType(generatedBy = SnowflakeIdGeneratorAccomplish.class)
@Retention(RUNTIME)
@Target({ FIELD, METHOD })
public @interface SnowflakeIdGenerator {
}
