/* (C) 2024 YiRing, Inc. */
package com.yiring.common.utils;

import jakarta.servlet.http.HttpServletRequest;
import lombok.experimental.UtilityClass;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

/**
 * 作用域工具类
 *
 * @author Jim
 * @version 0.1
 */

@UtilityClass
public class Contexts {

    /**
     * 获取当前请求
     *
     * @return HttpServletRequest
     */
    public HttpServletRequest getRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        assert requestAttributes != null;
        return (HttpServletRequest) requestAttributes.resolveReference(RequestAttributes.REFERENCE_REQUEST);
    }
}
