/* (C) 2022 YiRing, Inc. */
package com.yiring.common.validation.group;

import jakarta.validation.groups.Default;

/**
 * validate group
 * 预设一些全局公用的参数参数分组
 *
 * @author Jim
 * @version 0.1
 * 2022/11/10 11:46
 */
@SuppressWarnings("unused")
public interface Group {
    /**
     * 数据添加分组
     */
    interface Add extends Default {}

    /**
     * 数据修改分组
     */
    interface Edit extends Default {}

    /**
     * 数据查询分组
     */
    interface Query extends Default {}

    /**
     * 通用的必填分组
     */
    interface Required extends Default {}

    /**
     * 可选的分组
     */
    interface Optional {}
}
