/* (C) 2024 YiRing, Inc. */
package com.yiring.common.util;

import com.xxl.job.core.biz.model.ReturnT;
import com.yiring.common.core.UptimeNotice;
import lombok.experimental.UtilityClass;
import lombok.extern.slf4j.Slf4j;

/**
 * XxlJob 工具类
 *
 * @author Jim
 */
@SuppressWarnings("unused")
@Slf4j
@UtilityClass
public class XxlJobUtil {

    /**
     * 成功返回
     *
     * @param message 返回消息
     * @return ReturnT
     */
    public ReturnT<UptimeNotice> success(String message) {
        ReturnT<UptimeNotice> result = new ReturnT<>();
        result.setMsg(message);
        result.setCode(ReturnT.SUCCESS_CODE);
        result.setContent(UptimeNotice.ok(message));
        return result;
    }

    /**
     * 失败返回
     *
     * @param message 返回消息
     * @return ReturnT
     */
    public ReturnT<UptimeNotice> fail(String message) {
        ReturnT<UptimeNotice> result = new ReturnT<>();
        result.setMsg(message);
        result.setCode(ReturnT.FAIL_CODE);
        result.setContent(UptimeNotice.no(message));
        return result;
    }
}
