/* (C) 2022 YiRing, Inc. */
package com.yiring.common.param;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import java.io.Serial;
import java.io.Serializable;
import lombok.*;
import lombok.experimental.FieldDefaults;

/**
 * MinIO 文件下载请求参数（可补充实现对私有桶的文件下载）
 *
 * @author Jim
 * @version 0.1
 * 2022/7/5 15:29
 */

@Schema(name = "DownloadParam", description = "文件下载请求参数")
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
public class DownloadParam implements Serializable {

    @Serial
    private static final long serialVersionUID = -8690942241103456899L;

    @Schema(name = "bucket", example = "public")
    @NotEmpty(message = "存储桶不能为空")
    String bucket;

    @Schema(name = "object", example = "cat.jpg")
    @NotEmpty(message = "文件对象不能为空")
    String object;
}
