/* (C) 2022 YiRing, Inc. */
package com.yiring.common.service;

import java.io.File;
import org.springframework.web.multipart.MultipartFile;

/**
 * 文件上传媒体文件预处理服务
 *
 * @author Jim
 * @version 0.1
 * 2022/9/23 16:31
 */
public interface UploadProcessService {
    /**
     * 对文件进行预处理，例如:
     * 图片：haha.png -> haha.89x120.png 记录图片宽高，宽 = 89px，高 = 120px
     * PDF：haha.pdf -> haha.P12.pdf 记录 PDF 文件总页数，P12 即代表 PDF 总共 12 页，同时可通过 haha.P12.pdf.1.jpg... 按序号读取到每一页 PDF 对应的图片
     * 音视频：haha.mp3/4 -> haha.T12.mp3/4 记录音视频的时长（秒），T12 即代表音视频时长为 12 秒
     * 视频封面：haha.mp4 -> haha.mp4.jpg 截取视频封面
     *
     * @param object 上传文件存储地址
     * @param file   上传的文件
     * @return 预处理后的文件地址（可能对文件名追加了时长、页数、分辨率等标识）
     */
    default String handle(String object, MultipartFile file) {
        return object;
    }

    /**
     * 对媒体文件进行预处理，例如: 音视频
     *
     * @param object 文件存储对象
     * @param file   文件
     * @return 预处理后的文件地址
     */
    default String handleMedia(String object, File file) {
        return object;
    }
}
