/* (C) 2022 YiRing, Inc. */
package com.yiring.dict.param;

import com.yiring.common.validation.group.Group;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import java.io.Serial;
import java.io.Serializable;
import lombok.*;
import lombok.experimental.FieldDefaults;

/**
 * 数据字典参数
 *
 * @author Jim
 * @version 0.1
 * 2022/3/25 17:09
 */

@Schema(name = "DictParam")
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
public class DictParam implements Serializable {

    @Serial
    private static final long serialVersionUID = -5755754262686183535L;

    @Parameter(description = "id", example = "1")
    @NotBlank(groups = { Group.Edit.class })
    String id;

    @Parameter(description = "字典名称", example = "性别")
    @NotBlank
    String name;

    @Parameter(description = "字典编号", example = "GENDER")
    @NotBlank
    String code;

    @Parameter(description = "字典描述")
    String description;
}
