/* (C) 2022 YiRing, Inc. */
package com.yiring.dict.param;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serial;
import java.io.Serializable;
import lombok.*;
import lombok.experimental.FieldDefaults;

/**
 * 数据字典选项下拉查询参数
 *
 * @author Jim
 * @version 0.1
 * 2022/3/25 17:09
 */

@Schema(name = "SelectorDictItemParam")
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
public class SelectorDictItemParam implements Serializable {

    @Serial
    private static final long serialVersionUID = -8165884102089982475L;

    @Parameter(description = "字典 ID", example = "1")
    String dictId;

    @Parameter(description = "字典 ID", example = "1")
    String dictCode;

    @Parameter(description = "是否禁用", example = "false")
    Boolean disabled;
}
