/* (C) 2022 YiRing, Inc. */
package com.yiring.websocket.registry;

import com.yiring.websocket.domain.StompPrincipal;
import java.util.Set;

/**
 * STOMP 用户注册器
 *
 * @author ifzm
 * @version 0.1
 * 2019/10/10 21:57
 */

public interface StompUserRegistry {
    /**
     * 获取所有在线的用户信息
     *
     * @return 用户信息集合
     */
    @SuppressWarnings("unused")
    Set<StompPrincipal> getUsers();

    /**
     * 获取所有在线用户的数量
     *
     * @return 在线用户的数量
     */
    @SuppressWarnings("unused")
    int getUserCount();

    /**
     * 根据SessionId获取用户信息
     *
     * @param sessionId sessionId
     * @return StompPrincipal
     */
    @SuppressWarnings("unused")
    StompPrincipal getUser(String sessionId);

    /**
     * 更新用户信息
     *
     * @param sessionId sessionId
     * @param principal StompPrincipal
     */
    void updateUser(String sessionId, StompPrincipal principal);
}
