/* (C) 2021 YiRing, Inc. */
package com.yiring.app;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.data.jpa.convert.threeten.Jsr310JpaConverters;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.scheduling.annotation.EnableScheduling;

/**
 * @author Jim
 */
@EntityScan(
    basePackageClasses = { Application.class, Jsr310JpaConverters.class },
    basePackages = Application.BASE_PACKAGES
)
@EnableScheduling
@EnableJpaAuditing
@EnableJpaRepositories(basePackages = Application.BASE_PACKAGES)
@SpringBootApplication(scanBasePackages = Application.BASE_PACKAGES)
public class Application {

    public static final String BASE_PACKAGES = "com.yiring";

    public static void main(String[] args) {
        SpringApplication.run(Application.class, args);
    }
}
