/* (C) 2022 YiRing, Inc. */
package com.yiring.app.domain.user;

import com.yiring.auth.domain.user.User;
import com.yiring.common.domain.BasicEntity;
import jakarta.persistence.*;
import java.io.Serial;
import java.io.Serializable;
import lombok.*;
import lombok.experimental.FieldDefaults;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;
import org.hibernate.annotations.Comment;

/**
 * 用户扩展
 *
 * @author Jim
 * @version 0.1
 * 2022/7/13 10:59
 */

@Getter
@Setter
@ToString
@SuperBuilder(toBuilder = true)
@NoArgsConstructor
@AllArgsConstructor
@FieldNameConstants
@FieldDefaults(level = AccessLevel.PRIVATE)
@Entity
@Table(name = "SYS_USER_EXTENSION", uniqueConstraints = @UniqueConstraint(columnNames = "user_id"))
@Comment("用户扩展表")
public class UserExtension extends BasicEntity implements Serializable {

    @Serial
    private static final long serialVersionUID = -1157047754883351972L;

    @Comment("用户")
    @OneToOne
    @JoinColumn(nullable = false, name = "user_id")
    User user;

    @Comment("性别")
    Integer gender;

    @Comment("年龄")
    Integer age;

    @Comment("简介")
    String introduction;

    public UserExtension(User user) {
        this.user = user;
    }
}
