/* (C) 2022 YiRing, Inc. */
package com.yiring.auth.domain.user;

import java.io.Serializable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

/**
 * 用户接口
 *
 * @author ifzm
 * 2018/9/4 8:50
 */

@Repository
public interface UserRepository extends JpaRepository<User, Serializable>, JpaSpecificationExecutor<User> {
    /**
     * 根据用户名/手机号/邮箱查询用户信息
     *
     * @param account 账号
     * @return 用户信息
     */
    @Query("SELECT u FROM User u WHERE u.username = ?1 OR u.mobile = ?1 OR u.email = ?1")
    User findByAccount(String account);
}
