/* (C) 2021 YiRing, Inc. */
package com.yiring.auth.param.auth;

import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serial;
import java.io.Serializable;
import lombok.*;
import lombok.experimental.FieldDefaults;

/**
 * 验证码校验参数
 *
 * @author ifzm
 * @version 0.1
 * 2019/5/28 22:11
 */

@Schema(name = "CaptchaParam")
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
public class CaptchaParam implements Serializable {

    @Serial
    private static final long serialVersionUID = 2482112377591343046L;

    @Schema(description = "验证码校验标识", example = "b6523c1198f64602aea006238a744de7")
    String captchaKey;

    @Schema(description = "验证码识别结果", example = "vLUF4")
    String captchaCode;
}
