/* (C) 2021 YiRing, Inc. */
package com.yiring.auth.vo.auth;

import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serial;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.*;
import lombok.experimental.FieldDefaults;

/**
 * 验证码输出信息
 *
 * @author ifzm
 * @version 0.1
 * 2019/5/28 22:11
 */

@Schema(name = "CaptchaVo")
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
public class CaptchaVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 5303746889633243114L;

    @Schema(description = "验证码唯一标识", example = "b6523c1198f64602aea006238a744de7")
    String key;

    @Schema(description = "验证码图片 Base64", example = "data:image/jpg;base64,iV==")
    String data;

    @Schema(description = "验证码过期时间", example = "2024-01-01 00:00:00")
    LocalDateTime expire;
}
