/* (C) 2021 YiRing, Inc. */
package com.yiring.auth.vo.auth;

import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serial;
import java.io.Serializable;
import lombok.*;
import lombok.experimental.FieldDefaults;

/**
 * 用户登录输出信息
 *
 * @author ifzm
 * @version 0.1
 * 2019/5/28 22:11
 */

@Schema(name = "LoginVo")
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
public class LoginVo implements Serializable {

    @Serial
    private static final long serialVersionUID = -8690942241103456896L;

    @Schema(description = "用户 ID", example = "1")
    String userId;

    @Schema(description = "token", example = "c68ca9c8c04b4a59afeafd2fb7c04741")
    String token;
}
