/*
 Navicat Premium Data Transfer

 Source Server         : localhost_3306
 Source Server Type    : MySQL
 Source Server Version : 80025
 Source Host           : 127.0.0.1:3306
 Source Schema         : basic_app

 Target Server Type    : MySQL
 Target Server Version : 80025
 File Encoding         : 65001

 Date: 17/04/2022 18:00:26
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for sys_permission
-- ----------------------------
DROP TABLE IF EXISTS `sys_permission`;
CREATE TABLE `sys_permission`  (
  `id` varchar(255) NOT NULL COMMENT '主键',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime(6) NULL DEFAULT NULL COMMENT '最后修改时间',
  `component` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '组件',
  `enable` bit(1) NULL DEFAULT NULL COMMENT '是否启用',
  `hidden` bit(1) NULL DEFAULT NULL COMMENT '是否隐藏',
  `icon` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '图标',
  `meta` json NULL COMMENT '扩展元数据信息',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '名称',
  `path` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '路径',
  `pid` varchar(255) NULL DEFAULT NULL COMMENT '权限父级ID',
  `redirect` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '重定向',
  `serial` int NULL DEFAULT NULL COMMENT '序号',
  `tree` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '树节点标识',
  `type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '类型(MENU: 菜单, BUTTON: 按钮)',
  `uid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '标识',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `UK_n5idwm5pmlgfwvau5vrwf65ai`(`uid`) USING BTREE,
  INDEX `IDXfgtwjg4pmylcko0v6ate29j2x`(`type`) USING BTREE,
  INDEX `IDXcj5qpen847f3vkcgy7lsmqyug`(`pid`) USING BTREE,
  INDEX `IDXckpwmqmt2tsu8fyefxpgwypmr`(`tree`) USING BTREE,
  UNIQUE INDEX `UKn5idwm5pmlgfwvau5vrwf65ai`(`uid`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '系统权限' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_permission
-- ----------------------------
INSERT INTO `sys_permission` VALUES ('1515550180340928512', '2022-04-17 12:38:15.212000', '2022-04-17 12:38:15.212000', 'LAYOUT', b'1', NULL, 'ion:grid-outline', '{"title": "routes.dashboard.dashboard", "hideChildrenInMenu": true}', 'Dashboard', '/dashboard', 0, '/dashboard/workbench', 1, '0', 'MENU', 'Dashboard');
INSERT INTO `sys_permission` VALUES ('1515627442394370048', '2022-04-17 17:45:15.941000', '2022-04-17 17:45:15.941000', '/dashboard/workbench/index', b'1', b'1', NULL, '{"title": "routes.dashboard.workbench", "hideBreadcrumb": true, "currentActiveMenu": "/dashboard", "hideChildrenInMenu": true}', 'Workbench', 'workbench', '1515550180340928512', NULL, 1, '0.1515550180340928512', 'MENU', 'Workbench');
INSERT INTO `sys_permission` VALUES ('1515627944716800000', '2022-04-17 17:47:15.683000', '2022-04-17 17:47:15.683000', 'LAYOUT', b'1', NULL, 'simple-icons:about-dot-me', '{"title": "routes.dashboard.about", "hideChildrenInMenu": true}', 'About', '/about', 0, '/about/index', 100000, '0', 'MENU', 'About');
INSERT INTO `sys_permission` VALUES ('1515628470086930432', '2022-04-17 17:49:20.941000', '2022-04-17 17:49:20.942000', '/sys/about/index', b'1', NULL, 'simple-icons:about-dot-me', '{"title": "routes.dashboard.about", "hideMenu": true}', 'AboutPage', 'index', '1515627944716800000', NULL, NULL, '0.1515627944716800000', 'MENU', 'AboutPage');

-- ----------------------------
-- Table structure for sys_role
-- ----------------------------
DROP TABLE IF EXISTS `sys_role`;
CREATE TABLE `sys_role`  (
  `id` varchar(255) NOT NULL COMMENT '主键',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime(6) NULL DEFAULT NULL COMMENT '最后修改时间',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '名称',
  `uid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '标识',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `UK_o928jdlxprqf5qyw6rvor4lse`(`uid`) USING BTREE,
  UNIQUE INDEX `UKo928jdlxprqf5qyw6rvor4lse`(`uid`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '系统角色' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_role
-- ----------------------------
INSERT INTO `sys_role` VALUES ('1515628618854699008', '2022-04-17 17:49:56.420000', '2022-04-17 17:51:12.854000', '超级管理员', 'admin');

-- ----------------------------
-- Table structure for sys_role_permissions
-- ----------------------------
DROP TABLE IF EXISTS `sys_role_permissions`;
CREATE TABLE `sys_role_permissions`  (
  `role_id` varchar(255) NOT NULL,
  `permissions_id` varchar(255) NOT NULL,
  PRIMARY KEY (`role_id`, `permissions_id`) USING BTREE,
  INDEX `FKrg8k5oymm622ik067yjss31co`(`permissions_id`) USING BTREE,
  CONSTRAINT `FKaa4k4qhr2qdj6br8p5nrb2lhb` FOREIGN KEY (`role_id`) REFERENCES `sys_role` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `FKrg8k5oymm622ik067yjss31co` FOREIGN KEY (`permissions_id`) REFERENCES `sys_permission` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_role_permissions
-- ----------------------------
INSERT INTO `sys_role_permissions` VALUES ('1515628618854699008', '1515550180340928512');
INSERT INTO `sys_role_permissions` VALUES ('1515628618854699008', '1515627442394370048');
INSERT INTO `sys_role_permissions` VALUES ('1515628618854699008', '1515627944716800000');
INSERT INTO `sys_role_permissions` VALUES ('1515628618854699008', '1515628470086930432');

-- ----------------------------
-- Table structure for sys_user
-- ----------------------------
DROP TABLE IF EXISTS `sys_user`;
CREATE TABLE `sys_user`  (
  `id` varchar(255) NOT NULL COMMENT '主键',
  `create_time` datetime(6) NULL DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime(6) NULL DEFAULT NULL COMMENT '最后修改时间',
  `avatar` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '头像',
  `deleted` bit(1) NULL DEFAULT NULL COMMENT '是否删除',
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '邮箱',
  `enabled` bit(1) NULL DEFAULT NULL COMMENT '是否启用',
  `introduction` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '简介',
  `last_login_ip` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '最后登录IP地址',
  `last_login_time` datetime(6) NULL DEFAULT NULL COMMENT '最后登录时间',
  `mobile` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '手机号',
  `password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '密码',
  `real_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '真实姓名',
  `username` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '用户名',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `UK_ahtq5ew3v0kt1n7hf1sgp7p8l`(`email`) USING BTREE,
  UNIQUE INDEX `UK_cvv4commjv5h4bai0h4vuqvkd`(`mobile`) USING BTREE,
  UNIQUE INDEX `UK_51bvuyvihefoh4kp5syh2jpi4`(`username`) USING BTREE,
  UNIQUE INDEX `UKcvv4commjv5h4bai0h4vuqvkd`(`mobile`) USING BTREE,
  UNIQUE INDEX `UK51bvuyvihefoh4kp5syh2jpi4`(`username`) USING BTREE,
  UNIQUE INDEX `UKahtq5ew3v0kt1n7hf1sgp7p8l`(`email`) USING BTREE,
  INDEX `IDXeyi36w6acltgl5j4ujw0wlsyt`(`enabled`) USING BTREE,
  INDEX `IDXner7sjf2kjerehlptwipdlst9`(`deleted`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '系统用户' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_user
-- ----------------------------
INSERT INTO `sys_user` VALUES ('1515549486414303232', '2022-04-17 12:35:29.860000', '2022-04-17 17:55:47.785000', 'https://s1.ax1x.com/2022/03/30/qggJH0.jpg', b'0', NULL, b'1', '平台管理员', '0:0:0:0:0:0:0:1', '2022-04-17 17:55:47.784000', '13012345678', '8d969eef6ecad3c29a3a629280e686cf0c3f5d5a86aff3ca12020c923adc6c92', '管理员', 'admin');

-- ----------------------------
-- Table structure for sys_user_roles
-- ----------------------------
DROP TABLE IF EXISTS `sys_user_roles`;
CREATE TABLE `sys_user_roles`  (
  `user_id` varchar(255) NOT NULL,
  `role_id` varchar(255) NOT NULL,
  PRIMARY KEY (`role_id`, `user_id`) USING BTREE,
  INDEX `FKp2804vh0ea810pitigxq5n6pn`(`user_id`) USING BTREE,
  CONSTRAINT `FKp2804vh0ea810pitigxq5n6pn` FOREIGN KEY (`user_id`) REFERENCES `sys_user` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `FKqwiuml6b7mjmk48u5b9hmk853` FOREIGN KEY (`role_id`) REFERENCES `sys_role` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_user_roles
-- ----------------------------
INSERT INTO `sys_user_roles` VALUES ('1515549486414303232', '1515628618854699008');

-- ----------------------------
-- Table structure for test_table
-- ----------------------------
DROP TABLE IF EXISTS `test_table`;
CREATE TABLE `test_table`  (
  `id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '主键',
  `age` int NULL DEFAULT NULL COMMENT '年龄',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '姓名',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '测试表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of test_table
-- ----------------------------
INSERT INTO `test_table` VALUES ('1', 18, 'yiring.com');

SET FOREIGN_KEY_CHECKS = 1;
