/*
 Navicat Premium Data Transfer

 Source Server         : 192.168.0.156_5432
 Source Server Type    : PostgreSQL
 Source Server Version : 130003
 Source Host           : 192.168.0.156:5432
 Source Catalog        : basic_app
 Source Schema         : public

 Target Server Type    : PostgreSQL
 Target Server Version : 130003
 File Encoding         : 65001

 Date: 27/05/2022 14:09:18
*/


-- ----------------------------
-- Table structure for sys_permission
-- ----------------------------
DROP TABLE IF EXISTS "public"."sys_permission";
CREATE TABLE "public"."sys_permission" (
  "id" varchar(255) COLLATE "pg_catalog"."default" NOT NULL,
  "create_time" timestamp(6) NOT NULL,
  "update_time" timestamp(6) NOT NULL,
  "component" varchar(255) COLLATE "pg_catalog"."default",
  "enable" bool,
  "hidden" bool,
  "icon" varchar(255) COLLATE "pg_catalog"."default",
  "meta" json,
  "name" varchar(255) COLLATE "pg_catalog"."default",
  "path" varchar(255) COLLATE "pg_catalog"."default",
  "pid" varchar(255) COLLATE "pg_catalog"."default",
  "redirect" varchar(255) COLLATE "pg_catalog"."default",
  "serial" int4,
  "tree" varchar(255) COLLATE "pg_catalog"."default",
  "type" varchar(255) COLLATE "pg_catalog"."default",
  "uid" varchar(255) COLLATE "pg_catalog"."default" NOT NULL
)
;
COMMENT ON COLUMN "public"."sys_permission"."id" IS '主键';
COMMENT ON COLUMN "public"."sys_permission"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."sys_permission"."update_time" IS '最后修改时间';
COMMENT ON COLUMN "public"."sys_permission"."component" IS '组件';
COMMENT ON COLUMN "public"."sys_permission"."enable" IS '是否启用';
COMMENT ON COLUMN "public"."sys_permission"."hidden" IS '是否隐藏';
COMMENT ON COLUMN "public"."sys_permission"."icon" IS '图标';
COMMENT ON COLUMN "public"."sys_permission"."meta" IS '扩展元数据信息';
COMMENT ON COLUMN "public"."sys_permission"."name" IS '名称';
COMMENT ON COLUMN "public"."sys_permission"."path" IS '路径';
COMMENT ON COLUMN "public"."sys_permission"."pid" IS '权限父级ID';
COMMENT ON COLUMN "public"."sys_permission"."redirect" IS '重定向';
COMMENT ON COLUMN "public"."sys_permission"."serial" IS '序号';
COMMENT ON COLUMN "public"."sys_permission"."tree" IS '树节点标识';
COMMENT ON COLUMN "public"."sys_permission"."type" IS '类型(MENU: 菜单, BUTTON: 按钮)';
COMMENT ON COLUMN "public"."sys_permission"."uid" IS '标识';
COMMENT ON TABLE "public"."sys_permission" IS '系统权限';

-- ----------------------------
-- Records of sys_permission
-- ----------------------------
INSERT INTO "public"."sys_permission" VALUES ('1515627442394370048', '2022-04-17 17:45:15.941', '2022-05-17 18:48:22.001', '/dashboard/workbench/index', 't', 't', NULL, '{"title": "routes.dashboard.workbench", "hideBreadcrumb": true, "currentActiveMenu": "/dashboard", "hideChildrenInMenu": true}', 'Workbenchdddd', 'workbench', '1515550180340928512', NULL, 1, '0.1515550180340928512', 'BUTTON', 'Workbench');
INSERT INTO "public"."sys_permission" VALUES ('1515627944716800000', '2022-04-17 17:47:15.683', '2022-05-25 16:18:06.724', 'LAYOUT', 't', NULL, 'simple-icons:about-dot-me', '{"title": "routes.dashboard.about", "hideChildrenInMenu": true}', 'About', '/about', '0', NULL, 100000, '0', 'MENU', 'About');
INSERT INTO "public"."sys_permission" VALUES ('1515628470086930432', '2022-04-17 17:49:20.941', '2022-05-17 18:02:15.969', '/sys/about/index', 'f', 't', 'simple-icons:about-dot-me', '{"title": "routes.dashboard.about", "hideMenu": true}', 'AboutPage', 'index', '1515627944716800000', NULL, NULL, '0.1515627944716800000', 'BUTTON', 'AboutPage');
INSERT INTO "public"."sys_permission" VALUES ('1515550180340928512', '2022-04-17 12:38:15.212', '2022-05-24 17:50:13.742', 'LAYOUT', 't', 't', 'ion:grid-outline', '{"title": "routes.dashboard.dashboard", "hideChildrenInMenu": true}', 'Dashboard', '/dashboard', '0', '/dashboard/workbench', 1, '0', 'MENU', 'Dashboard');

-- ----------------------------
-- Table structure for sys_role
-- ----------------------------
DROP TABLE IF EXISTS "public"."sys_role";
CREATE TABLE "public"."sys_role" (
  "id" varchar(255) COLLATE "pg_catalog"."default" NOT NULL,
  "create_time" timestamp(6) NOT NULL,
  "update_time" timestamp(6) NOT NULL,
  "name" varchar(255) COLLATE "pg_catalog"."default",
  "uid" varchar(255) COLLATE "pg_catalog"."default" NOT NULL
)
;
COMMENT ON COLUMN "public"."sys_role"."id" IS '主键';
COMMENT ON COLUMN "public"."sys_role"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."sys_role"."update_time" IS '最后修改时间';
COMMENT ON COLUMN "public"."sys_role"."name" IS '名称';
COMMENT ON COLUMN "public"."sys_role"."uid" IS '标识';
COMMENT ON TABLE "public"."sys_role" IS '系统角色';

-- ----------------------------
-- Records of sys_role
-- ----------------------------
INSERT INTO "public"."sys_role" VALUES ('1530064847847297024', '2022-05-27 13:54:21.623', '2022-05-27 13:54:21.624', '管理员', 'admin');

-- ----------------------------
-- Table structure for sys_role_permissions
-- ----------------------------
DROP TABLE IF EXISTS "public"."sys_role_permissions";
CREATE TABLE "public"."sys_role_permissions" (
  "role_id" varchar(255) COLLATE "pg_catalog"."default" NOT NULL,
  "permissions_id" varchar(255) COLLATE "pg_catalog"."default" NOT NULL
)
;

-- ----------------------------
-- Records of sys_role_permissions
-- ----------------------------
INSERT INTO "public"."sys_role_permissions" VALUES ('1530064847847297024', '1515627442394370048');
INSERT INTO "public"."sys_role_permissions" VALUES ('1530064847847297024', '1515627944716800000');
INSERT INTO "public"."sys_role_permissions" VALUES ('1530064847847297024', '1515628470086930432');
INSERT INTO "public"."sys_role_permissions" VALUES ('1530064847847297024', '1515550180340928512');

-- ----------------------------
-- Table structure for sys_user
-- ----------------------------
DROP TABLE IF EXISTS "public"."sys_user";
CREATE TABLE "public"."sys_user" (
  "id" varchar(255) COLLATE "pg_catalog"."default" NOT NULL,
  "create_time" timestamp(6) NOT NULL,
  "update_time" timestamp(6) NOT NULL,
  "avatar" varchar(255) COLLATE "pg_catalog"."default",
  "deleted" bool,
  "email" varchar(255) COLLATE "pg_catalog"."default",
  "enabled" bool,
  "introduction" varchar(255) COLLATE "pg_catalog"."default",
  "last_login_ip" varchar(255) COLLATE "pg_catalog"."default",
  "last_login_time" timestamp(6),
  "mobile" varchar(255) COLLATE "pg_catalog"."default",
  "password" varchar(255) COLLATE "pg_catalog"."default",
  "real_name" varchar(255) COLLATE "pg_catalog"."default",
  "username" varchar(255) COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."sys_user"."id" IS '主键';
COMMENT ON COLUMN "public"."sys_user"."create_time" IS '创建时间';
COMMENT ON COLUMN "public"."sys_user"."update_time" IS '最后修改时间';
COMMENT ON COLUMN "public"."sys_user"."avatar" IS '头像';
COMMENT ON COLUMN "public"."sys_user"."deleted" IS '是否删除';
COMMENT ON COLUMN "public"."sys_user"."email" IS '邮箱';
COMMENT ON COLUMN "public"."sys_user"."enabled" IS '是否启用';
COMMENT ON COLUMN "public"."sys_user"."introduction" IS '简介';
COMMENT ON COLUMN "public"."sys_user"."last_login_ip" IS '最后登录IP地址';
COMMENT ON COLUMN "public"."sys_user"."last_login_time" IS '最后登录时间';
COMMENT ON COLUMN "public"."sys_user"."mobile" IS '手机号';
COMMENT ON COLUMN "public"."sys_user"."password" IS '密码';
COMMENT ON COLUMN "public"."sys_user"."real_name" IS '真实姓名';
COMMENT ON COLUMN "public"."sys_user"."username" IS '用户名';
COMMENT ON TABLE "public"."sys_user" IS '系统用户';

-- ----------------------------
-- Records of sys_user
-- ----------------------------
INSERT INTO "public"."sys_user" VALUES ('1530062713596678144', '2022-05-27 13:45:52.805', '2022-05-27 13:45:57.318', 'https://s1.ax1x.com/2022/03/30/qggJH0.jpg', 'f', NULL, 't', '平台管理员', '127.0.0.1', '2022-05-27 13:45:57.309', '13012345678', '8d969eef6ecad3c29a3a629280e686cf0c3f5d5a86aff3ca12020c923adc6c92', '管理员', 'admin');

-- ----------------------------
-- Table structure for sys_user_roles
-- ----------------------------
DROP TABLE IF EXISTS "public"."sys_user_roles";
CREATE TABLE "public"."sys_user_roles" (
  "role_id" varchar(255) COLLATE "pg_catalog"."default" NOT NULL,
  "user_id" varchar(255) COLLATE "pg_catalog"."default" NOT NULL
)
;

-- ----------------------------
-- Records of sys_user_roles
-- ----------------------------
INSERT INTO "public"."sys_user_roles" VALUES ('1530064847847297024', '1530062713596678144');

-- ----------------------------
-- Table structure for test_table
-- ----------------------------
DROP TABLE IF EXISTS "public"."test_table";
CREATE TABLE "public"."test_table" (
  "id" varchar(255) COLLATE "pg_catalog"."default" NOT NULL,
  "age" int4,
  "name" varchar(255) COLLATE "pg_catalog"."default"
)
;
COMMENT ON COLUMN "public"."test_table"."id" IS '主键';
COMMENT ON COLUMN "public"."test_table"."age" IS '年龄';
COMMENT ON COLUMN "public"."test_table"."name" IS '姓名';
COMMENT ON TABLE "public"."test_table" IS '测试表';

-- ----------------------------
-- Records of test_table
-- ----------------------------

-- ----------------------------
-- Indexes structure for table sys_permission
-- ----------------------------
CREATE INDEX "idxcj5qpen847f3vkcgy7lsmqyug" ON "public"."sys_permission" USING btree (
  "pid" COLLATE "pg_catalog"."default" "pg_catalog"."text_ops" ASC NULLS LAST
);
CREATE INDEX "idxckpwmqmt2tsu8fyefxpgwypmr" ON "public"."sys_permission" USING btree (
  "tree" COLLATE "pg_catalog"."default" "pg_catalog"."text_ops" ASC NULLS LAST
);
CREATE INDEX "idxfgtwjg4pmylcko0v6ate29j2x" ON "public"."sys_permission" USING btree (
  "type" COLLATE "pg_catalog"."default" "pg_catalog"."text_ops" ASC NULLS LAST
);

-- ----------------------------
-- Uniques structure for table sys_permission
-- ----------------------------
ALTER TABLE "public"."sys_permission" ADD CONSTRAINT "uk_n5idwm5pmlgfwvau5vrwf65ai" UNIQUE ("uid");

-- ----------------------------
-- Primary Key structure for table sys_permission
-- ----------------------------
ALTER TABLE "public"."sys_permission" ADD CONSTRAINT "sys_permission_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Uniques structure for table sys_role
-- ----------------------------
ALTER TABLE "public"."sys_role" ADD CONSTRAINT "uko928jdlxprqf5qyw6rvor4lse" UNIQUE ("uid");

-- ----------------------------
-- Primary Key structure for table sys_role
-- ----------------------------
ALTER TABLE "public"."sys_role" ADD CONSTRAINT "sys_role_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table sys_role_permissions
-- ----------------------------
ALTER TABLE "public"."sys_role_permissions" ADD CONSTRAINT "sys_role_permissions_pkey" PRIMARY KEY ("role_id", "permissions_id");

-- ----------------------------
-- Indexes structure for table sys_user
-- ----------------------------
CREATE INDEX "idxeyi36w6acltgl5j4ujw0wlsyt" ON "public"."sys_user" USING btree (
  "enabled" "pg_catalog"."bool_ops" ASC NULLS LAST
);
CREATE INDEX "idxner7sjf2kjerehlptwipdlst9" ON "public"."sys_user" USING btree (
  "deleted" "pg_catalog"."bool_ops" ASC NULLS LAST
);

-- ----------------------------
-- Uniques structure for table sys_user
-- ----------------------------
ALTER TABLE "public"."sys_user" ADD CONSTRAINT "uk_ahtq5ew3v0kt1n7hf1sgp7p8l" UNIQUE ("email");
ALTER TABLE "public"."sys_user" ADD CONSTRAINT "uk_cvv4commjv5h4bai0h4vuqvkd" UNIQUE ("mobile");
ALTER TABLE "public"."sys_user" ADD CONSTRAINT "uk_51bvuyvihefoh4kp5syh2jpi4" UNIQUE ("username");

-- ----------------------------
-- Primary Key structure for table sys_user
-- ----------------------------
ALTER TABLE "public"."sys_user" ADD CONSTRAINT "sys_user_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table sys_user_roles
-- ----------------------------
ALTER TABLE "public"."sys_user_roles" ADD CONSTRAINT "sys_user_roles_pkey" PRIMARY KEY ("role_id", "user_id");

-- ----------------------------
-- Primary Key structure for table test_table
-- ----------------------------
ALTER TABLE "public"."test_table" ADD CONSTRAINT "test_table_pkey" PRIMARY KEY ("id");

-- ----------------------------
-- Foreign Keys structure for table sys_role_permissions
-- ----------------------------
ALTER TABLE "public"."sys_role_permissions" ADD CONSTRAINT "fkaa4k4qhr2qdj6br8p5nrb2lhb" FOREIGN KEY ("role_id") REFERENCES "public"."sys_role" ("id") ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE "public"."sys_role_permissions" ADD CONSTRAINT "fkrg8k5oymm622ik067yjss31co" FOREIGN KEY ("permissions_id") REFERENCES "public"."sys_permission" ("id") ON DELETE NO ACTION ON UPDATE NO ACTION;

-- ----------------------------
-- Foreign Keys structure for table sys_user_roles
-- ----------------------------
ALTER TABLE "public"."sys_user_roles" ADD CONSTRAINT "fkp2804vh0ea810pitigxq5n6pn" FOREIGN KEY ("user_id") REFERENCES "public"."sys_user" ("id") ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE "public"."sys_user_roles" ADD CONSTRAINT "fkqwiuml6b7mjmk48u5b9hmk853" FOREIGN KEY ("role_id") REFERENCES "public"."sys_role" ("id") ON DELETE NO ACTION ON UPDATE NO ACTION;
