/* (C) 2022 YiRing, Inc. */
package com.yiring.common.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import lombok.RequiredArgsConstructor;
import org.n52.jackson.datatype.jts.JtsModule;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * Jackson Config
 *
 * @author Jim
 * @version 0.1
 * 2022/4/17 16:54
 */

@Configuration
@RequiredArgsConstructor
public class JacksonConfig {

    final JavaTimeModule javaTimeModule;

    @Bean
    public ObjectMapper objectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        // 忽略空值（序列化）
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        // 忽略未知字段（反序列化）
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        // Java 8 Date/Time support
        mapper.registerModule(javaTimeModule);
        // JTS Geometry support
        mapper.registerModule(new JtsModule());

        // TODO: add AdminServerModule

        return mapper;
    }
}
