/* (C) 2022 YiRing, Inc. */
package com.yiring.common.exception;

import com.yiring.common.core.I18n;
import com.yiring.common.core.Status;
import java.io.Serial;
import lombok.AccessLevel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NonNull;
import lombok.experimental.FieldDefaults;
import org.jetbrains.annotations.PropertyKey;

/**
 * 业务状态异常
 *
 * @author Jim
 * @version 0.1
 * 2022/3/28 11:36
 */

@SuppressWarnings("unused")
@EqualsAndHashCode(callSuper = true)
@Data
@FieldDefaults(level = AccessLevel.PRIVATE)
public class BusinessException extends RuntimeException {

    @Serial
    private static final long serialVersionUID = -4226669531686389671L;

    /**
     * 状态码
     */
    Status status;

    /**
     * 业务状态异常消息
     */
    String message;

    public BusinessException(Status status, @PropertyKey(resourceBundle = I18n.RESOURCE_BUNDLE) String message) {
        this.status = status;
        this.message = message;
    }

    public static BusinessException i18n(@PropertyKey(resourceBundle = I18n.RESOURCE_BUNDLE) String message) {
        return new BusinessException(Status.BAD_REQUEST, message);
    }

    public static BusinessException i18n(
        @NonNull Status status,
        @PropertyKey(resourceBundle = I18n.RESOURCE_BUNDLE) String message
    ) {
        return new BusinessException(status, message);
    }
}
