/* (C) 2022 YiRing, Inc. */
package com.yiring.common.exception;

import com.yiring.common.core.Status;
import java.io.Serial;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.FieldDefaults;

/**
 * Status 异常（用于快速失败，会进行全局异常拦截）
 *
 * @author Jim
 * @version 0.1
 * 2022/3/28 11:36
 */

@EqualsAndHashCode(callSuper = true)
@Data
@AllArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
public class FailStatusException extends RuntimeException {

    @Serial
    private static final long serialVersionUID = -4226669531686389671L;

    /**
     * 状态
     */
    Status status;

    /**
     * 异常消息
     */
    String message;
}
