/* (C) 2022 YiRing, Inc. */
package com.yiring.common.exception;

import java.io.Serial;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.FieldDefaults;

/**
 * Uptime 异常
 * 搭配 @UptimePush 注解可实现快速上报监控结果
 *
 * @author Jim
 * @version 0.1
 * 2022/3/28 11:36
 */

@EqualsAndHashCode(callSuper = true)
@Data
@AllArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
public class UptimeException extends RuntimeException {

    @Serial
    private static final long serialVersionUID = -4226669531686389671L;

    /**
     * 异常消息
     */
    String message;
}
