/* (C) 2021 YiRing, Inc. */
package com.yiring.common.param;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import java.io.Serial;
import java.io.Serializable;
import lombok.*;
import lombok.experimental.FieldDefaults;

/**
 * 公共的关键字查询参数类
 *
 * @author ifzm
 * @version 0.1
 * 2022/4/27 08:53
 */
@Schema(name = "KeywordParam", description = "公共的关键字查询参数")
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
public class KeywordParam implements Serializable {

    @Serial
    private static final long serialVersionUID = -8690942241103456894L;

    @Parameter(description = "关键字", example = "hi")
    @NotBlank
    String keyword;
}
