/* (C) 2022 YiRing, Inc. */
package com.yiring.common.config;

import io.minio.MinioClient;
import lombok.AccessLevel;
import lombok.Data;
import lombok.experimental.FieldDefaults;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * Minio 配置注入
 *
 * @author Jim
 * @version 0.1
 * 2021/9/16 16:37
 */

@Data
@FieldDefaults(level = AccessLevel.PRIVATE)
@Configuration
@ConfigurationProperties(prefix = "minio")
public class MinioConfig {

    /**
     * 通常是内网地址
     */
    String endpoint;
    /**
     * 账户/访问标识
     */
    String accessKey;
    /**
     * 密码/认证密钥
     */
    String secretKey;
    /**
     * 默认储存桶名称
     */
    String bucket;
    /**
     * 通常是和 endpoint 相对的外网地址
     */
    String domain;

    @Bean
    public MinioClient getClient() {
        return MinioClient.builder().endpoint(endpoint).credentials(accessKey, secretKey).build();
    }
}
