/* (C) 2023 YiRing, Inc. */
package com.yiring.common.param;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotEmpty;
import java.io.Serial;
import java.io.Serializable;
import lombok.*;
import lombok.experimental.FieldDefaults;
import org.springframework.validation.annotation.Validated;

/**
 * 上传分片参数
 *
 * @author Jim
 * @version 0.1
 * 2023/7/27 18:16
 */
@Schema(name = "UploadChunkParam", description = "分片上传参数")
@Validated
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
public class UploadChunkParam implements Serializable {

    @Serial
    private static final long serialVersionUID = 3118356781129185420L;

    @Schema(description = "文件名", defaultValue = "test.png", example = "test.png")
    @NotEmpty(message = "文件名不能为空")
    String name;

    @Schema(description = "文件大小", defaultValue = "1024", example = "1024", type = "long")
    @NotEmpty(message = "文件大小不能为空")
    @Min(0)
    Long size;

    @Schema(description = "文件类型", defaultValue = "image/png", example = "image/png")
    @NotEmpty(message = "文件类型不能为空")
    String type;

    @Schema(description = "文件扩展", defaultValue = "png", example = "png")
    @NotEmpty(message = "文件扩展不能为空")
    String ext;

    @Schema(description = "文件 md5", defaultValue = "md5", example = "md5")
    @NotEmpty(message = "文件 md5不能为空")
    String md5;

    @Schema(description = "文件分片总数", defaultValue = "10", example = "10", type = "integer")
    @NotEmpty(message = "文件分片总数不能为空")
    @Min(1)
    Integer chunks;

    @Schema(description = "当前分片", defaultValue = "1", example = "1", type = "integer")
    @NotEmpty(message = "当前分片不能为空")
    @Min(0)
    Integer chunkIndex;

    @Schema(description = "分片文件大小", defaultValue = "1024", example = "1024", type = "long")
    @NotEmpty(message = "分片文件大小不能为空")
    @Min(0)
    Long chunkSize;

    /**
     * 可以记录与业务相关的数据标识等描述信息
     */
    @Schema(description = "自定义扩展参数")
    String extra;
}
