/* (C) 2023 YiRing, Inc. */
package com.yiring.dict.domain;

import static com.yiring.common.domain.BasicEntity.Where.WHERE_ID;
import static com.yiring.dict.domain.DictItem.TABLE_NAME;

import com.yiring.common.domain.BasicEntity;
import jakarta.persistence.*;
import java.io.Serial;
import java.io.Serializable;
import lombok.*;
import lombok.experimental.FieldDefaults;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;
import org.hibernate.annotations.Comment;
import org.hibernate.annotations.SQLDelete;

/**
 * 字典选项
 *
 * @author Jim
 * @version 0.1
 * 2023/1/20 13:58
 */

@Getter
@Setter
@SuperBuilder(toBuilder = true)
@NoArgsConstructor
@AllArgsConstructor
@FieldNameConstants
@FieldDefaults(level = AccessLevel.PRIVATE)
@SQLDelete(sql = Category.DELETE_SQL + WHERE_ID)
//@SQLDeleteAll(sql = Category.DELETE_SQL)
@Entity
@Table(
    name = TABLE_NAME,
    indexes = {
        @Index(columnList = BasicEntity.Fields.deleted),
        @Index(columnList = DictItem.Fields.name),
        @Index(columnList = DictItem.Fields.disabled),
    }
)
@Comment("数据字典选项")
public class DictItem extends BasicEntity implements Serializable {

    public static final String TABLE_NAME = "SYS_DICT_ITEM";
    public static final String DELETE_SQL = "update " + TABLE_NAME + Where.DELETE_SET;

    @Serial
    private static final long serialVersionUID = -7321430621819435483L;

    @Comment("字典")
    @ManyToOne
    @JoinColumn(nullable = false)
    Dict dict;

    @Comment("字典选项名称")
    @Column(nullable = false)
    String name;

    @Comment("字典选项值")
    @Column(nullable = false)
    String value;

    @Comment("字典选项描述")
    String description;

    @Comment("字典选项排序序号")
    Integer serial;

    @Comment("是否禁用")
    @Column(columnDefinition = "bool default false", nullable = false)
    Boolean disabled;
}
