/* (C) 2022 YiRing, Inc. */
package com.yiring.dict.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serial;
import java.io.Serializable;
import lombok.*;
import lombok.experimental.FieldDefaults;

/**
 * 数据字典选项输出
 *
 * @author Jim
 * @version 0.1
 * 2022/3/25 17:09
 */

@Schema(name = "DictItemVo")
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@FieldDefaults(level = AccessLevel.PRIVATE)
public class DictItemVo implements Serializable {

    @Serial
    private static final long serialVersionUID = -5041312962732993815L;

    @Schema(description = "id", example = "1")
    String id;

    @Schema(description = "字典选项名称", example = "男")
    String name;

    @Schema(description = "字典选项值", example = "1")
    String value;

    @Schema(description = "字典选项描述")
    String description;

    @Schema(description = "字典选项排序序号", example = "1")
    Integer serial;

    @Schema(description = "是否禁用", example = "false")
    Boolean disabled;
}
